<?php
/* --------------------------------------------------------------
   PermissionDefinition.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Permission;

/**
 * Interface PermissionDefinition
 *
 * @package Gambio\Core\Permission
 */
interface PermissionDefinition
{
    /**
     * Returns the identifier.
     *
     * @return string
     */
    public function identifier(): string;
    
    
    /**
     * Returns the type.
     *
     * @return string
     */
    public function type(): string;
    
    
    /**
     * Returns the action.
     *
     * @return string
     */
    public function action(): string;
}